#!/usr/bin/env python
import pandas as pd
import numpy as np

path = "data/lenses_dr5_random.csv"
df = pd.read_csv(path)
print("Columns:", list(df.columns))

if "RG_kpc" in df.columns:
    print("RG_kpc already exists, nothing to do.")
elif "R_G_kpc" in df.columns:
    print("Using R_G_kpc to create RG_kpc.")
    df["RG_kpc"] = df["R_G_kpc"]
    df.to_csv(path, index=False)
    print("Done.")
elif "R_G_bin" in df.columns:
    print("Deriving RG_kpc from R_G_bin midpoints.")
    def mid(label):
        if not isinstance(label, str):
            return np.nan
        s = label.replace("–", "-").strip("[]()")
        a, b = s.split("-")
        return 0.5*(float(a) + float(b))
    df["RG_kpc"] = df["R_G_bin"].apply(mid)
    df.to_csv(path, index=False)
    print("Done.")
else:
    print("No source for RG_kpc found.")
